# IP Beacon V3.5 - Professional Network Forensics Tool

**Created by George A. Rauscher | intelligent piXel GmbH**  
**License:** MIT (see LICENSE file)  
**Version:** 3.5  
**Release Date:** November 13, 2025

---

## What is IP Beacon?

IP Beacon is a professional grade network analysis tool designed for IT specialists, forensic experts, security researchers, and privacy conscious users. It provides comprehensive real time network diagnostics, privacy scoring, and security analysis - all running client side in your browser with zero data storage on any server.

Built by a forensic expert with over 30 years of experience in IT security and software development, IP Beacon combines professional depth with user friendly design.

---

## Key Features

### IP Analysis
- Detect public IPv4 and IPv6 addresses
- Geolocation with city, region, country
- ISP and organization information
- Timezone and postal code detection

### Device Information
- Browser detection and version
- Operating system details
- Screen resolution and pixel ratio
- Device type (desktop, mobile, tablet)
- CPU cores and memory information
- Language and timezone settings

### Privacy Score
- Real time privacy risk assessment
- WebRTC leak detection
- Browser fingerprinting analysis
- Ad blocker detection
- Cookie and storage analysis
- Do Not Track status

### Network Tests
- Download speed measurement
- Upload speed estimation
- Ping latency testing
- DNS resolution performance
- Multiple test sources (Cloudflare, Google, Amazon)

### Port Scanner
- Common port availability check
- HTTP, HTTPS, FTP, SSH, SMTP, DNS, MySQL, PostgreSQL detection
- Visual status indicators

### Security Information
- SSL/TLS certificate analysis
- Certificate expiration dates
- Encryption strength detection
- Security recommendations

### Export Functions
- PDF export per card
- Global PDF export (all data)
- Clean, professional formatting

---

## Technology Stack

- **Frontend:** Pure HTML5, CSS3, Vanilla JavaScript ES6+
- **APIs:** ipify.org, ipapi.co, Cloudflare CDN
- **Icons:** Lucide Icons (ISC License)
- **PDF:** jsPDF (MIT License)
- **Architecture:** Zero knowledge, client side only
- **Privacy:** No server side data storage, GDPR compliant

---

## Installation

See `INSTALL.md` for detailed step by step instructions.

### Quick Start (Server Installation)

1. Download and extract the ZIP file
2. Upload all files to your web server
3. Edit `index.html` and add your legal notice (Impressum) in the designated section
4. Adjust `sitemap.xml` to match your domain
5. Adjust `robots.txt` to match your domain
6. Open in browser - done!

**No database, no backend, no configuration files needed.**

### Quick Start (Local Usage - PC/Mac/Linux)

**Want to run it locally without a server? No problem!**

1. Download and extract the ZIP file
2. Double click `index.html` to open in your browser
3. That's it! It works immediately.

**No installation required. No server needed. Just open the HTML file.**

Perfect for:
- IT professionals who need a quick diagnostic tool
- Offline network analysis (limited functionality without internet for APIs)
- Portable toolkit on USB stick
- Quick checks without cloud dependencies

**Note:** Some features require internet connection (IP detection via ipify.org, geolocation via ipapi.co, network tests). But the tool runs 100% client side in your browser - no data is sent to any server except the external API providers.

---

## Browser Compatibility

- Chrome/Edge 90+
- Firefox 88+
- Safari 14+
- Opera 76+
- All modern mobile browsers

---

## Privacy & Security

### Zero Knowledge Architecture
All analysis runs in your browser. No data is ever sent to any server owned by the operator of this tool. External API calls are made directly from your browser to third party services (ipify, ipapi, Cloudflare).

### GDPR Compliance
This tool does not store, process, or transmit personal data to any server. All processing happens client side. Users must review and comply with the privacy policies of external API providers.

### External Services Used
- **ipify.org** - IP address detection
- **ipapi.co** - Geolocation data
- **cloudflare.com** - Network performance tests

---

## Customization

### Branding
You can customize the tool while keeping the footer credit as required by the license:

1. Change colors in CSS variables (line ~150)
2. Modify header text and description
3. Add your logo
4. Adjust meta tags for SEO

### Features
You can disable specific features by commenting out the respective functions in the JavaScript code. All functions are well documented with nerdy comments.

---

## Credits

**Created by:** George A. Rauscher  
**Organization:** intelligent piXel GmbH (IIFE)  
**Website:** https://www.intelligent-pixel.com  
**Contact:** george@rauscher.xyz

**Built with:**
- Lucide Icons - https://lucide.dev
- jsPDF - https://github.com/parallax/jsPDF
- Love for clean code and privacy

---

## Disclaimer

See `DISCLAIMER.md` for full legal disclaimer.

This software is provided "as is" without warranty of any kind. The analysis results are for informational purposes only and should not be used as the sole basis for security related decisions.

---

## Support

If you find this tool useful, please:
- Star the project (if on GitHub)
- Share it with your network
- Give credit where credit is due
- Consider a donation (optional, not required)

---

## Changelog

### Version 3.5 (November 13, 2025)
- Complete UI redesign in pure grayscale
- Added 6 feature cards for better organization
- PDF export functionality (per card and global)
- Mobile and iPhone optimization
- Maximum SEO optimization
- Enhanced privacy score algorithm
- Improved network testing with fallbacks
- Added extensive code documentation
- GDPR compliant privacy policy
- MIT License for open source distribution

### Version 3.1 (Previous)
- Initial public release

---

## License

MIT License - See LICENSE file for details.

**Attribution Required:** You must keep the footer credit with link to https://www.intelligent-pixel.com

---

**Built with passion for privacy, security, and clean code.**  
**George A. Rauscher - Forensic Expert since 1995**

