# Installation Guide - IP Beacon V3.5

This guide will help you install IP Beacon on your web server in under 5 minutes.

---

## Requirements

### Server Requirements
- **Web Server:** Apache 2.4+ or Nginx 1.18+
- **PHP:** Not required (pure client side)
- **Database:** Not required
- **SSL Certificate:** Recommended (for HTTPS)
- **Disk Space:** ~2 MB

### Browser Requirements (for visitors)
- Modern browser with JavaScript enabled
- Support for Web Crypto API
- Support for Fetch API

---

## Installation Steps

### Step 1: Download and Extract

1. Download `IP-Beacon-V3.5-OpenSource.zip`
2. Extract the ZIP file to your computer
3. You should see these files:
   ```
   IP-Beacon-V3.5-OpenSource/
   ├── LICENSE
   ├── README.md
   ├── INSTALL.md
   ├── DISCLAIMER.md
   ├── index.html
   ├── robots.txt
   ├── sitemap.xml
   └── llms.txt
   ```

### Step 2: Upload to Web Server

#### Via FTP/SFTP
1. Connect to your web server using FileZilla, WinSCP, or similar
2. Navigate to your web root (usually `/var/www/html` or `/public_html`)
3. Upload all files from the extracted folder
4. Ensure file permissions are set correctly (644 for files, 755 for directories)

#### Via SSH/Terminal
```bash
# Upload via scp
scp -r IP-Beacon-V3.5-OpenSource/* user@yourserver.com:/var/www/html/

# Or if already on server
cd /var/www/html
# Upload files here

# Set correct permissions
chmod 644 *.html *.txt *.xml *.md
chmod 755 .
```

### Step 3: Customize Your Installation

#### Required: Add Your Legal Notice

Edit `index.html` and find this section (around line 1000):

```html
<h3>Legal Notice (Impressum)</h3>
<p><strong>Responsible Party:</strong><br>
[YOUR NAME OR COMPANY]<br>
[YOUR ADDRESS]<br>
[YOUR CITY, ZIP CODE]<br>
[YOUR COUNTRY]</p>

<p><strong>Contact:</strong><br>
Email: [YOUR EMAIL]<br>
Website: [YOUR WEBSITE]</p>
```

Replace the placeholders with your actual information.

#### Required: Update Domain References

1. **Edit `sitemap.xml`:**
   Replace all instances of `https://my.0at.de/` with your domain

2. **Edit `robots.txt`:**
   Replace `Sitemap: https://my.0at.de/sitemap.xml` with your domain

3. **Edit `llms.txt`:**
   Update the URL field with your domain

4. **Edit `index.html` meta tags:**
   Update these meta tags (around line 26-45):
   ```html
   <link rel="canonical" href="https://YOUR-DOMAIN.com/">
   <meta property="og:url" content="https://YOUR-DOMAIN.com/">
   <meta name="twitter:url" content="https://YOUR-DOMAIN.com/">
   ```

#### Optional: Customize Branding

**Change Colors:**
Edit `index.html` around line 150, modify CSS variables:
```css
:root {
    --background: #0d0d0d;      /* Main background */
    --card-dark: #1a1a1a;       /* Card background */
    --text-primary: #e0e0e0;    /* Primary text */
    /* Add your custom colors */
}
```

**Modify Header:**
Edit around line 800:
```html
<div class="header">
    <h1>YOUR CUSTOM TITLE</h1>
    <p>Your custom description</p>
</div>
```

### Step 4: Test Your Installation

1. Open your browser
2. Navigate to `https://your-domain.com/`
3. Check that:
   - ✅ Page loads without errors
   - ✅ IP address is detected
   - ✅ All cards show data
   - ✅ PDF export works
   - ✅ No console errors (F12 → Console)

### Step 5: SEO Configuration

#### Submit to Google Search Console

1. Go to https://search.google.com/search-console
2. Add your domain
3. Verify ownership (DNS, HTML file, or meta tag)
4. Submit sitemap: `https://your-domain.com/sitemap.xml`

#### robots.txt Verification

Visit `https://your-domain.com/robots.txt` and verify it's accessible.

---

## Web Server Configuration

### Apache (.htaccess)

Create a `.htaccess` file in your installation directory:

```apache
# Force HTTPS (recommended)
RewriteEngine On
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]

# Compression
<IfModule mod_deflate.c>
    AddOutputFilterByType DEFLATE text/html text/css application/javascript
</IfModule>

# Browser Caching
<IfModule mod_expires.c>
    ExpiresActive On
    ExpiresByType text/html "access plus 1 hour"
    ExpiresByType text/css "access plus 1 month"
    ExpiresByType application/javascript "access plus 1 month"
</IfModule>

# Security Headers
<IfModule mod_headers.c>
    Header set X-Content-Type-Options "nosniff"
    Header set X-Frame-Options "SAMEORIGIN"
    Header set X-XSS-Protection "1; mode=block"
</IfModule>
```

### Nginx Configuration

Add to your `nginx.conf` or site config:

```nginx
server {
    listen 443 ssl http2;
    server_name your-domain.com;

    root /var/www/html;
    index index.html;

    # SSL Configuration (adjust paths)
    ssl_certificate /path/to/cert.pem;
    ssl_certificate_key /path/to/key.pem;

    # Compression
    gzip on;
    gzip_types text/html text/css application/javascript;

    # Security Headers
    add_header X-Content-Type-Options "nosniff" always;
    add_header X-Frame-Options "SAMEORIGIN" always;
    add_header X-XSS-Protection "1; mode=block" always;

    # Caching
    location ~* \.(css|js)$ {
        expires 1M;
        add_header Cache-Control "public, immutable";
    }
}
```

---

## Troubleshooting

### Problem: Page loads but no data appears

**Solution:**
- Check browser console (F12) for errors
- Verify external APIs are accessible (ipify.org, ipapi.co, cloudflare.com)
- Check if your firewall blocks API requests
- Try from a different network

### Problem: PDF export doesn't work

**Solution:**
- Verify jsPDF CDN is loading (check Network tab in DevTools)
- Try a different browser
- Ensure pop-up blocker isn't blocking the download

### Problem: Mobile layout broken

**Solution:**
- Clear browser cache
- Verify viewport meta tag is present in `<head>`
- Test in multiple mobile browsers

### Problem: Google not indexing

**Solution:**
- Wait 7-14 days after submitting sitemap
- Verify robots.txt allows crawling
- Check for manual penalties in Search Console
- Ensure site is accessible via HTTPS

---

## Performance Optimization

### Cloudflare Setup (Recommended)

1. Sign up at cloudflare.com
2. Add your domain
3. Update nameservers
4. Enable:
   - Auto Minify (HTML, CSS, JS)
   - Brotli compression
   - Rocket Loader
   - HTTP/3

### Local Optimizations

1. **Minify HTML:**
   ```bash
   # Using html-minifier
   html-minifier --collapse-whitespace --remove-comments index.html -o index.min.html
   ```

2. **Enable HTTP/2:**
   Ensure your web server supports HTTP/2 (most modern servers do)

---

## Security Best Practices

1. **Always use HTTPS** - Get free SSL from Let's Encrypt
2. **Keep server updated** - Regular security patches
3. **Limit file permissions** - 644 for files, 755 for directories
4. **Monitor access logs** - Watch for suspicious activity
5. **Regular backups** - Backup at least weekly

---

## Need Help?

- Check the README.md for feature documentation
- Review DISCLAIMER.md for legal information
- Contact: george@rauscher.xyz (for critical issues only)
- Community support: Search online forums

---

## Post-Installation Checklist

- [ ] All files uploaded successfully
- [ ] Legal notice (Impressum) customized
- [ ] Domain references updated (sitemap, robots, llms, meta tags)
- [ ] HTTPS enabled
- [ ] Page loads without errors
- [ ] All features tested (IP detection, PDF export, etc.)
- [ ] Console shows no errors
- [ ] Sitemap submitted to Google Search Console
- [ ] robots.txt accessible
- [ ] Mobile view tested

---

**Installation complete! Your IP Beacon is now live.**

Share it, use it, and respect privacy. 🛡️

---

*Last updated: November 13, 2025*  
*For IP Beacon V3.5 by George A. Rauscher*

