# Disclaimer - IP Beacon V3.5

**Last Updated:** November 13, 2025  
**Version:** 3.5  
**Author:** George A. Rauscher | intelligent piXel GmbH

---

## 1. General Information

IP Beacon is a network analysis and forensic tool provided free of charge for informational and educational purposes. By using this software, you acknowledge and agree to the terms outlined in this disclaimer.

---

## 2. No Warranty

This software is provided "as is" without warranty of any kind, either express or implied, including but not limited to the implied warranties of merchantability, fitness for a particular purpose, or non infringement.

**We do not guarantee:**
- Accuracy of analysis results
- Completeness of displayed data
- Timeliness of information
- Availability of external services
- Compatibility with all browsers or devices
- Freedom from bugs or errors

---

## 3. Limitation of Liability

To the extent legally permissible, George A. Rauscher and intelligent piXel GmbH shall not be liable for any direct, indirect, incidental, special, consequential, or punitive damages arising out of or related to:

- Use or inability to use this software
- Reliance on analysis results
- Decisions made based on displayed information
- Data loss or corruption
- Privacy breaches
- Security incidents
- Third party actions

**Liability for slight negligence is excluded.** We are only liable for violation of essential contractual obligations in cases of slight negligence. Liability for indirect damages, consequential damages, and lost profits is excluded.

---

## 4. External APIs

IP Beacon uses external third party APIs to provide its functionality:

- **ipify.org** - IP address detection
- **ipapi.co** - Geolocation data
- **cloudflare.com** - Network performance tests
- **Lucide Icons CDN** - Icon library
- **jsPDF CDN** - PDF generation

**We assume no liability for:**
- Availability, accuracy, or legality of these external services
- Privacy policies of third party providers
- Changes to API functionality
- Service interruptions or data breaches at third party providers

**Your responsibility:**
- Review and comply with the terms of service and privacy policies of all external providers
- Understand that data is transmitted to these third parties
- Accept the risks associated with using external services

---

## 5. Accuracy of Analysis Results

The analysis results provided by IP Beacon (including IP addresses, geolocation, network data, privacy score, and other metrics) are for **informational purposes only**.

**We do not guarantee:**
- Correctness of IP geolocation (can be off by hundreds of miles)
- Accuracy of ISP information
- Completeness of port scan results
- Reliability of privacy scores
- Precision of network performance measurements

**These results should not be used as:**
- The sole basis for security related decisions
- Evidence in legal proceedings without independent verification
- Proof of identity or location
- Professional security assessments

---

## 6. Not Professional Advice

IP Beacon is an analysis tool and **does not replace professional IT security consulting**.

For security related questions, critical infrastructure protection, or forensic investigations, we strongly recommend consulting a qualified IT security expert or certified forensic analyst.

---

## 7. User Responsibilities

**You are responsible for:**
- Ensuring your use complies with applicable laws and regulations
- Obtaining necessary permissions before analyzing networks you do not own
- Respecting privacy rights of others
- Not using this tool for illegal activities
- Not using results to harm, harass, or stalk individuals
- Keeping your installation secure and up to date
- Adding your own legal notice (Impressum) as required by law
- Complying with GDPR and other privacy regulations in your jurisdiction

**Prohibited uses include but are not limited to:**
- Unauthorized network scanning or penetration testing
- Stalking or doxxing individuals
- Circumventing security measures
- Collecting data for spam or fraud
- Any illegal or unethical purposes

---

## 8. Copyright

The content and works created by IP Beacon are subject to German copyright law.

**You may:**
- Use, modify, and distribute this software under the MIT License terms
- Customize the tool for your needs
- Deploy it on your own infrastructure

**You must:**
- Retain the copyright notice and attribution
- Keep the footer credit: "Powered by George A. Rauscher | intelligent piXel GmbH"
- Include the LICENSE file in all distributions
- Not claim the software as your own creation

**Prohibited:**
- Reproduction, editing, distribution, or exploitation outside the limits of copyright law requires written consent from the respective author or creator

---

## 9. Data Protection and Privacy

### Data We Collect
IP Beacon itself **does not collect, store, or transmit any user data to our servers**. All analysis happens client side in your browser.

### Third Party Data Collection
External APIs (ipify, ipapi, Cloudflare) may collect:
- Your IP address
- Browser user agent
- Timestamp of requests
- Geolocation data

**Your responsibility:**
- Review privacy policies of external services
- Inform your users about third party data collection
- Comply with GDPR and applicable privacy laws
- Add cookie consent if required in your jurisdiction

### Installation on Your Server
If you install IP Beacon on your own server, **you are the data controller** and responsible for:
- Adding your own privacy policy
- Implementing required cookie consent
- Handling any server logs that may contain visitor IPs
- GDPR compliance for your installation

---

## 10. Modifications and Customization

You are free to modify this software under the MIT License terms. However:

**We are not responsible for:**
- Bugs or issues introduced by your modifications
- Security vulnerabilities in customized versions
- Functionality of third party integrations you add
- Legal compliance of your modified version

**Recommendation:**
- Test thoroughly before deploying modifications
- Keep security best practices in mind
- Document your changes
- Consider contributing improvements back to the community

---

## 11. Updates and Maintenance

**No obligation for updates:**
We are under no obligation to provide updates, bug fixes, or new features. This software is provided as is, and future development is at our discretion.

**Version compatibility:**
We do not guarantee backward compatibility between versions. Major updates may require reinstallation or reconfiguration.

---

## 12. Dispute Resolution

The European Commission provides a platform for online dispute resolution available at:  
**https://ec.europa.eu/consumers/odr**

We are neither willing nor obligated to participate in dispute resolution proceedings before a consumer arbitration board.

---

## 13. Governing Law

This disclaimer and any disputes arising from the use of this software shall be governed by the laws of the Federal Republic of Germany, excluding international sales law (UN Convention on Contracts for the International Sale of Goods).

---

## 14. Severability

If any provision of this disclaimer is found to be invalid or unenforceable, the remaining provisions shall continue to be valid and enforceable to the fullest extent permitted by law.

---

## 15. Changes to This Disclaimer

We reserve the right to update this disclaimer at any time without prior notice. The current version is always available in the DISCLAIMER.md file included with the software distribution.

**Your responsibility:**
Check for updates regularly, especially before major deployments.

---

## 16. Acceptance

**By using IP Beacon, you acknowledge that you have read, understood, and agreed to this disclaimer.**

If you do not agree to these terms, you must not use this software.

---

## Contact

**For critical legal or security issues only:**

George A. Rauscher  
intelligent piXel GmbH  
Enzianstraße 4a  
82319 Starnberg  
Germany

Email: george@rauscher.xyz  
Website: https://www.intelligent-pixel.com

**Note:** We cannot provide free support, customization services, or legal advice. For general questions, please refer to the README.md and INSTALL.md files.

---

## Summary (TL;DR)

- ✅ Free to use under MIT License
- ❌ No warranty, use at your own risk
- ❌ Not professional advice
- ❌ We're not liable for damages
- ✅ You're responsible for legal compliance
- ✅ External APIs have their own terms
- ✅ Keep attribution and footer credit
- ❌ Don't use for illegal purposes
- ✅ Test before deploying
- ✅ Read the full disclaimer above

---

**Use responsibly. Respect privacy. Build secure systems.**

---

*This disclaimer was last updated on November 13, 2025 for IP Beacon V3.5*  
*George A. Rauscher - Forensic Expert | intelligent piXel GmbH*

